-- $RCSfile: mult_gen_v8_0_xst_comp.vhd,v $ $Revision: 1.8 $ $Date: 2008/09/08 19:37:47 $
--------------------------------------------------------------------------------
--  Copyright(C) 2005 by Xilinx, Inc. All rights reserved.
--  This text/file contains proprietary, confidential
--  information of Xilinx, Inc., is distributed under license
--  from Xilinx, Inc., and may be used, copied and/or
--  disclosed only pursuant to the terms of a valid license
--  agreement with Xilinx, Inc.  Xilinx hereby grants you
--  a license to use this text/file solely for design, simulation,
--  implementation and creation of design files limited
--  to Xilinx devices or technologies. Use with non-Xilinx
--  devices or technologies is expressly prohibited and
--  immediately terminates your license unless covered by
--  a separate agreement.
--
--  Xilinx is providing this design, code, or information
--  "as is" solely for use in developing programs and
--  solutions for Xilinx devices.  By providing this design,
--  code, or information as one possible implementation of
--  this feature, application or standard, Xilinx is making no
--  representation that this implementation is free from any
--  claims of infringement.  You are responsible for
--  obtaining any rights you may require for your implementation.
--  Xilinx expressly disclaims any warranty whatsoever with
--  respect to the adequacy of the implementation, including
--  but not limited to any warranties or representations that this
--  implementation is free from claims of infringement, implied
--  warranties of merchantability or fitness for a particular
--  purpose.
--
--  Xilinx products are not intended for use in life support
--  appliances, devices, or systems. Use in such applications are
--  expressly prohibited.
--
--  This copyright and support notice must be retained as part
--  of this text at all times. (c) Copyright 1995-2005 Xilinx, Inc.
--  All rights reserved.
--------------------------------------------------------------------------------
-----------------------------------------------------------------------
--
-- Use VHDL package bb_comps to define black box components to be
-- generated by a synthesis tool.
--
-- This file should not be copied over to the export area
-- unless it is specifically required by the synthesis tool.
--
-- Try to ensue that the file-sets processed by XCC and the synthesis
-- tool is disjoint.
--
-----------------------------------------------------------------------

LIBRARY IEEE;
USE IEEE.std_logic_1164.ALL;

PACKAGE mult_gen_v8_0_xst_comp IS

----------------------------------------------------------
-- Insert component declaration of top level xst file here
----------------------------------------------------------
  COMPONENT mult_gen_v8_0_xst
    GENERIC (
      c_family          : STRING  := "not_set";
      c_xdevicefamily   : STRING  := "not_set";
      c_a_width         : INTEGER := 18;          -- vector width of operand A
      c_b_width         : INTEGER := 18;          -- vector width of operand B
      c_out_width       : INTEGER := 36;          -- vector width of the output
      c_has_q           : INTEGER := 1;  -- generate a registered output dout
      c_has_o           : INTEGER := 0;  -- generate a non-registered output NOTE: core can produce both a registered and a non-registered output.
      c_reg_a_b_inputs  : INTEGER := 0;  -- inputs A and B are registered
      c_a_type          : INTEGER := 0;  -- determines whether the operand A is signed, unsigned
      c_b_type          : INTEGER := 0;  -- determines whether the operand B is signed, unsigned
      c_b_value         : STRING  := "00000001";  -- value of operand B when constant
      c_has_aclr        : INTEGER := 0;  -- generate an asynchronous clear
      c_has_sclr        : INTEGER := 0;  -- generate a synchronous clear
      c_has_ce          : INTEGER := 0;  -- generate a clock enable
      c_mem_type        : INTEGER := 0;  -- defines whether the multiplier implementation uses single port block mem, dual port block mem,distributed mem
      c_mult_type       : INTEGER := 0;  -- determines which kind of multiplier to instantiate: 0- lut based parallel  1- Virtex II parallel  2- parallel CCM  3- static RCCM  4- dynamic RCCM
      c_elaboration_dir : STRING  := "./";
      c_has_nd          : INTEGER := 0;  -- generate a new data signal
      c_has_rdy         : INTEGER := 0;  -- generate a output ready signal
      c_has_rfd         : INTEGER := 0;  -- generate a ready for data signal
      c_pipeline        : INTEGER := 0;
      c_sync_enable     : INTEGER := 0;
      c_has_load_done   : INTEGER := 0;
      -- deprecated generics
      c_has_a_signed    : INTEGER := 0;  -- generate a signal to control the sign of operand A
      c_enable_rlocs    : INTEGER := 0;  -- enable relative placement
      c_has_loadb       : INTEGER := 0;  -- generate a signal to control the loading of constant operand B
      c_baat            : INTEGER := 0;
      c_has_swapb       : INTEGER := 0;  -- generate a multiplier busy signal
      c_b_constant      : INTEGER := 0;  -- operand B is a constant
      c_output_hold     : INTEGER := 0;
      c_sqm_type        : INTEGER := 0;
      c_has_b           : INTEGER := 0;
      c_stack_adders    : INTEGER := 0;
      bram_addr_width   : INTEGER := 0;
      c_mem_init_prefix : STRING  := "mem";
      c_standalone      : INTEGER := 0;
      c_use_luts        : INTEGER := 0;
      c_v2_speed        : INTEGER := 0
      );
    PORT (
      clk       : IN  STD_LOGIC                              := '1';
      a         : IN  STD_LOGIC_VECTOR(c_a_width-1 DOWNTO 0) := (OTHERS => '0');
      b         : IN  STD_LOGIC_VECTOR(c_b_width-1 DOWNTO 0) := (OTHERS => '0');
      o         : OUT STD_LOGIC_VECTOR(c_out_width-1 DOWNTO 0);
      q         : OUT STD_LOGIC_VECTOR(c_out_width-1 DOWNTO 0);
      a_signed  : IN  STD_LOGIC                              := '0';
      loadb     : IN  STD_LOGIC                              := '0';
      load_done : OUT STD_LOGIC;
      swapb     : IN  STD_LOGIC                              := '0';
      ce        : IN  STD_LOGIC                              := '1';
      aclr      : IN  STD_LOGIC                              := '0';
      sclr      : IN  STD_LOGIC                              := '0';
      rfd       : OUT STD_LOGIC;
      nd        : IN  STD_LOGIC                              := '0';
      rdy       : OUT STD_LOGIC
      );

  END COMPONENT;

END mult_gen_v8_0_xst_comp;
